<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van QUMT_IN900008NL - Subscription Registration Query (NL)</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <!--<pattern is-a="attentionLine" id="QUMT_IN900008NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId/hl7:value"/>
        </pattern>-->
    
    <pattern is-a="transmission-wrapper" id="QUMT_IN900008NL-wrapper">
        <param name="element" value="hl7:QUMT_IN900008NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="QUMT_IN900008NL-controlAct">
        <param name="element" value="hl7:QUMT_IN900008NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:QUMT_IN900008NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:QUMT_IN900008NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:QUMT_IN900008NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:QUMT_IN900008NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De zender van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:QUMT_IN900008NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De ontvanger van deze interactie moet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>QueryByParameter</title>
        <rule context="hl7:queryByParameter">
            <assert role="error" test="hl7:queryId"
                >queryId is verplicht</assert>
            <assert role="error" test="hl7:modifyCode"
                >modifyCode is verplicht</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:responseModalityCode">
            <assert role="error" test="@code='R'"
                >De responseModalityCode moet 'R' (Realtime) zijn.</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:modifyCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='N'"
                >modifyCode/@code moet 'N' zijn</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:assignedDeviceId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >Het attribuut <value-of select="local-name(..)"/>/value/@root moet de waarde “2.16.840.1.113883.2.4.6.6” bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:effectiveTime/hl7:value">
            <extends rule="IVL_TS"/>
            <assert role="error" test="count(hl7:*) = 1 and hl7:high/@value"
                >effectiveTime/value/high/@value (bovengrens) is verplicht en overige elementen zijn niet toegestaan</assert>
            <!--assert role="error" test="matches(hl7:high/@value,'^[0-9]{12}')"
                >effectiveTime/value/high/@value moet tenminste tot op de minuten zijn gespecificeerd</assert-->
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:eventCode/hl7:value">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.12'"
                >eventCode/value/@codeSystem moet de waarde “2.16.840.1.113883.2.4.3.11.12” bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:objectCode/hl7:value">
            <extends rule="CD"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.4' or @codeSystem='2.16.840.1.113883.6.1'"
                >objectCode/value/@root moet komen uit ActRegistrycodeNL (2.16.840.1.113883.2.4.15.4) of LOINC (2.16.840.1.113883.6.1).</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:subjectId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3' or @root='2.16.528.1.1007.3.1' or @root='2.16.528.1.1007.3.3'"
                >subjectId/value/@root moet de waarde '2.16.840.1.113883.2.4.6.3' (BSN), '2.16.528.1.1007.3.1' (UZI), of '2.16.528.1.1007.3.3' (URA) bevatten</assert>
        </rule>
    </pattern>
</schema>
